<?php
final class smslink
{
    protected $smslink_username;
    protected $smslink_password;
    protected $smslink_api = "http://www.smslink.ro/sms/gateway/communicate/index.php";

    private function setUsername($smslink_username)
    {
        $this->smslink_username = $smslink_username;
    }

    private function setPassword($smslink_password)
    {
        $this->smslink_password = $smslink_password;
    }

    public function setApi($username,$password)
    {
        $this->smslink_username = $username;
        $this->smslink_password = $password;
    }

    public function setsmslink($smslink_username, $smslink_password)
    {
        $this->setUsername($smslink_username);
        $this->setPassword($smslink_password);
    }

    public function smslink_prepare_message($order_id, $order_info, $data, $message)
    {
        $message = str_replace(
                            array(
                                '{order_id}',
                                '{order_total}',
                                '{order_status_comment}',
                                '{store_name}',
                                '{firstname}',
                                '{lastname}',
                                '{payment_method}',
                                '{shipping_method}'
                            ),
                            array(
                                $order_id,
                                sprintf("%.2f", $order_info['total'])." ".$order_info["currency_code"],
                                (isset($data["comment"])) ? $data["comment"] : "",
                                $order_info["store_name"],
                                $order_info["firstname"],
                                $order_info["lastname"],
                                $order_info["payment_method"],
                                $order_info["shipping_method"]
                            ),
                            $message
                        );

        return $message;

    }

    private function smslink_request($link)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $link);

        if (strpos($link, "https://") !== false)
        {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }

        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);

        $response = curl_exec($ch);

        $curl_errno = curl_errno($ch);
        $curl_error = curl_error($ch);

        curl_close($ch);

        if ($curl_errno != 0)
            $response = "ERROR;".$curl_errno.";".$curl_error;

        return $response;

    }

    public function smslink_balance($username = NULL, $password = NULL, $verify_api = 0)
    {
        if ((is_null($username)) and (is_null($password)) and ($verify_api == 0)) {
            if (!$this->smslink_username || !$this->smslink_password) {
                exit('Va rugam sa setati inainte Connection ID-ul si Parola asociate serviciului SMSLink - SMS Gateway.');
            }
            $username = $this->smslink_username;
            $password = $this->smslink_password;
        }

        $link = $this->smslink_api.
                "?mode=credit".
                "&connection_id=".urlencode($username).
                "&password=".urlencode($password);

        $result = explode(";", $this->smslink_request($link));

        if ($result[0] == "MESSAGE")
        {
            $result[3] = explode(",", $result[3]);
            $result = $result[3][0]." SMS";
        }
        else
        {
            $result = $result[1]." - ".$result[2];
        }

        return $result;

    }

    public function smslink_queue($destination, $message)
    {
        if (!$this->smslink_username || !$this->smslink_password) {
            exit('Va rugam sa setati inainte Connection ID-ul si Parola asociate serviciului SMSLink - SMS Gateway.');
        }

        $data = $this->smslink_api.'?'.
                '&connection_id='.urlencode($this->smslink_username).
                '&password='.urlencode($this->smslink_password).
                '&to='.urlencode($destination).
                '&message='.urlencode($message);

        $result = $this->smslink_request($data);

        return $result;

    }

}

?>