<?php

class SMSLinkTestSettings extends ModuleAdminController
{
    protected $index;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->meta_title = 'Testare Configuratie';
        $this->display = 'add';

        $this->context = Context::getContext();

        parent::__construct();

        $this->index = count($this->_conf) + 1;
        $this->_conf[$this->index] = 'Mesajul a fost transmis cu succes.';
        
    }

    public function renderForm()
    {
        $ConnectionID = strval(Configuration::get('SMSLINK_CONNECTION_ID'));

        $Password = strval(Configuration::get('SMSLINK_PASSWORD'));
        
        $Configured = true;
        if ((strlen($ConnectionID) == 0) or (strlen($ConnectionID) == 0))
            $Configured = false;
        
        $TestStatus = Configuration::get('SMSLINK_TEST');

        $TestPhone = $this->module->Phone(Configuration::get('SMSLINK_TEST_PHONE'));
        
        $this->fields_form = array(
            'legend' => array(
                'title' => 'Transmite un SMS pentru testarea setarilor cu SMSLink'
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => 'Numar de telefon',
                    'name' => 'Phone',
                    'size' => 40,
                    'required' => true,
                    'desc' => '<div>'.
                              (($TestStatus == 1) ? "<strong> Important! </strong>Modul de testare este activ, iar toate SMS-urile, exceptand SMS-urile transmise din aceasta sectiune, vor fi transmise la ".$TestPhone.". Pentru a dezactiva modul de testare sau pentru a schimba numarul de teste, accesati sectiunea de <a href='index.php?controller=AdminModules&configure=smslink&token=".Tools::getAdminTokenLite('AdminModules')."'>Configurare pentru modulul SMSLink</a>." : "").
                              (($Configured == false) ? "<strong> Atentie! </strong>Modulul SMSLink nu a fost configurat, lipsind datele de conectare catre platforma SMSLink. Pentru a finaliza configurarea, accesati sectiunea de <a href='index.php?controller=AdminModules&configure=smslink&token=".Tools::getAdminTokenLite('AdminModules')."'>Configurare pentru modulul SMSLink</a>." : "").
                              '</div>'                    
                ),
                array(
                    'type' => 'textarea',
                    'rows' => 2,
                    'label' => 'Text SMS',
                    'name' => 'Message',
                    'required' => true,
                    'class' => '',
                    'desc' => '<div><b>Situatia conexiunii dintre magazinul dvs. online si contul dvs. de utilizator de pe SMSLink:</b><br />'.$this->module->Credit(1).'</div>',
                )
                    
            ),
            'submit' => array(
                'title' => 'Trimite',
                'class' => 'btn btn-default pull-left'
            )
        );

        if (strlen($TestPhone) > 0) $this->fields_value['Phone'] = $TestPhone;
            else $this->fields_value['Phone'] = "0723123456";
            
        $this->fields_value['Message'] = 'Acesta este un SMS de test transmis de pe '.Configuration::get('PS_SHOP_NAME');
        
        if (!($obj = $this->loadObject(true))) 
            return true;

        $this->context->controller->addJS(
                Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/functions.js'
            );

        return parent::renderForm();
    }

    public function postProcess()
    {
        if (Tools::isSubmit('submitAdd'.$this->table)) 
        {
            $ConnectionID = strval(Configuration::get('SMSLINK_CONNECTION_ID'));

            $Password = strval(Configuration::get('SMSLINK_PASSWORD'));
            
            if ((strlen($ConnectionID) == 0) or (strlen($Password) == 0))

            {

                $this->errors[] = Tools::displayError('Pentru a putea efectua un test, este necesar sa completati Connection ID-ul si Password-ul asociate serviciilor dvs. in sectiunea de Configurare a acestui modul.');
                

            }
            else
            {
                $Phone = strval(Tools::getValue('Phone'));
                $Message = strval(Tools::getValue('Message'));
                            
                if (!empty($Phone) && !empty($Message)) 
                {
                    $this->module->QueueSMS($Phone, $Message, 1);
                    
                    Tools::redirectAdmin(self::$currentIndex.'&conf='.$this->index.'&token='.$this->token);
                    
                } 
                else 
                {
                    $this->errors[] = Tools::displayError('Numarul de telefon si mesajul nu pot fi lasate libere.');
                    
                }
            
            }
            
        }
        
    }
    
    public function initPageHeaderToolbar()

    {

        $this->page_header_toolbar_title = 'Transmite un SMS pentru testarea setarilor cu SMSLink';

        parent::initPageHeaderToolbar();


    }
    
}
