<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

class SMSLink extends Module
{
    protected $Configuration = array(
            'SMSLINK_CONNECTION_ID',
            'SMSLINK_PASSWORD',
            'SMSLINK_TEST',
            'SMSLINK_TEST_PHONE',
            'SMSLINK_STATUS'
        );
        
    public function __construct()
    {
        $this->name  = 'smslink';
        $this->tab    = 'emailing';        
        $this->author = 'ASTINVEST COM SRL';
        
        $this->version = '9.0.1';
        
        $this->need_instance = 0;        
        $this->ps_versions_compliancy = array(
                'min' => '9.0.0', 
                'max' => _PS_VERSION_
            );
                
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('SMSLink');
        $this->description = $this->l('Integrati fara efort magazinul dvs. online cu platforma SMSLink pentru a transmite notificari SMS catre clientii dvs., imbunatatind astfel comunicarea cu acestia.');

        $this->confirmUninstall = $this->l('Doriti sa dezinstalati modulul SMSLink pentru PrestaShop?');

        if (!Configuration::get('SMSLINK_CONNECTION_ID') || !Configuration::get('SMSLINK_PASSWORD'))
            $this->warning = $this->l('Credentialele pentru conectarea cu platforma SMSLink nu au fost configurate. Pentru configurare, accesati optiunea Configurare aferenta modulului SMSLink.');
               
        $this->agent = 'PS_Module_'.$this->version;        
    }

    private function installDb()
    {
        Db::getInstance()->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'smslink_log`;');

        if (!Db::getInstance()->Execute("CREATE TABLE `"._DB_PREFIX_."smslink_log` ( `id` BIGINT(20) NOT NULL AUTO_INCREMENT, `receiver` VARCHAR(50) NULL , `message` TEXT NULL , `timestamp_queued` datetime DEFAULT NULL , `timestamp_sent` datetime DEFAULT NULL , `remote_message_id` BIGINT(20) NOT NULL DEFAULT '0' , `remote_status` INT(2) NOT NULL DEFAULT '0' , `remote_response` TEXT NULL , PRIMARY KEY (`id`)) ENGINE="._MYSQL_ENGINE_." DEFAULT CHARSET=utf8"))
            return false;
        
        return true;        
    }

    private function uninstallDb()
    {
        if (!Db::getInstance()->Execute('DROP TABLE `'._DB_PREFIX_.'smslink_log`;'))
            return false;
        
        return true;        
    }

    public function install()
    {
        if (Shop::isFeatureActive())
            Shop::setContext(Shop::CONTEXT_ALL);
        
        if (!$this->installDb())
            return false;

        if (!parent::install()) 
            return false;
                
        if (!$this->registerHook('actionOrderStatusPostUpdate')) 
            return false;
       
        if (!$this->registerHook('displayAdminOrderMainBottom')) 
            return false;

        $tabNames = array();
        
        $result = Db::getInstance()->ExecuteS("SELECT * FROM `"._DB_PREFIX_."lang` ORDER BY `id_lang`");
                
        if (is_array($result)) 
        {
            foreach ($result as $row) 
            {
                $tabNames['main'][$row['id_lang']] = 'SMSLink';
                
                $tabNames['SMSLinkLog'][$row['id_lang']] = 'Istoric si Cautare SMS';
                $tabNames['SMSLinkConfiguration'][$row['id_lang']] = 'Configurare si Sabloane';
                $tabNames['SMSLinkTestSettings'][$row['id_lang']] = 'Testare Configuratie';                
            }            
        }
        
        $this->installModuleTab('SMSLinkTab', $tabNames['main']);
        
        $idTab = Tab::getIdFromClassName("SMSLinkTab");      
          
        $this->installModuleTab('SMSLinkLog', $tabNames['SMSLinkLog'], $idTab);
        $this->installModuleTab('SMSLinkConfiguration', $tabNames['SMSLinkConfiguration'], $idTab);
        $this->installModuleTab('SMSLinkTestSettings', $tabNames['SMSLinkTestSettings'], $idTab);

        return true;        
    }

    public function uninstall()
    {
        if (!parent::uninstall() || !$this->uninstallDb()) 
            return false;

        foreach ($this->Configuration as $config) 
            if (!Configuration::deleteByName($config)) 
                return false;                    

        $this->uninstallModuleTab('SMSLinkTab');
        
        $this->uninstallModuleTab('SMSLinkLog');
        $this->uninstallModuleTab('SMSLinkConfiguration');
        $this->uninstallModuleTab('SMSLinkTestSettings');

        return true;        
    }

    private function installModuleTab($tabClass, $tabName, $idTabParent = 0)
    {
        $tab = new Tab();
        $tab->name = $tabName;
        $tab->class_name = $tabClass;
        $tab->module = $this->name;
        $tab->id_parent = $idTabParent;

        if (!$tab->save())
            return false;

        return Tab::getIdFromClassName($tabClass);        
    }

    private function uninstallModuleTab($tabClass)
    {
        $idTab = Tab::getIdFromClassName($tabClass);
        
        if ($idTab != 0) 
        {
            $tab = new Tab($idTab);
            $tab->delete();
            return true;
        }
       
        return false;     
    }
    
    public function getContent()
    {
        $output = null;
        
        if (Tools::isSubmit('submit'.$this->name)) 
        {
            $ConnectionID = strval(Tools::getValue('SMSLINK_CONNECTION_ID'));
            $Password = strval(Tools::getValue('SMSLINK_PASSWORD'));
            
            $TestMode = strval(Tools::getValue('SMSLINK_TEST_'));            
            $TestPhone = strval(Tools::getValue('SMSLINK_TEST_PHONE'));
            
            $SecureMode = strval(Tools::getValue('SMSLINK_SECURE_'));
            
            $statuses = array();
            $orderStatuses = OrderState::getOrderStates($this->context->language->id);
            
            foreach ($orderStatuses as $status)
                $statuses[$status['id_order_state']] = strval(Tools::getValue('SMSLINK_STATUS_'.$status['id_order_state']));
            
            if ((strlen($ConnectionID) == 0) or (strlen($Password) == 0))
            {
                $output .= $this->displayError($this->l('Pentru a putea salva configuratia, este necesar sa completati Connection ID-ul si Password-ul asociate serviciilor dvs.'));
                
            } 
            else 
            {                
                if (!empty($TestPhone) && !Validate::isPhoneNumber($TestPhone)) 
                {
                    $output .= $this->displayError($this->l('Numarul de telefon pentru teste nu este valid.'));
                } 
                else 
                {
                    Configuration::updateValue('SMSLINK_TEST_PHONE', $TestPhone);
                }
                
                Configuration::updateValue('SMSLINK_CONNECTION_ID', $ConnectionID);              
                Configuration::updateValue('SMSLINK_PASSWORD', $Password);
                
                Configuration::updateValue('SMSLINK_TEST', !empty($TestMode) ? 1 : 0);
                Configuration::updateValue('SMSLINK_SECURE', !empty($SecureMode) ? 1 : 0);
                
                Configuration::updateValue('SMSLINK_STATUS', serialize($statuses));
                
                $output .= $this->displayConfirmation($this->l('Setarile dvs. au fost salvate cu succes.'));
                
            }
            
        }
        
        return $output.$this->displayForm();
    }

    public function displayForm()
    {
        $this->context->controller->addJS(
                Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/functions.js'
            );
        
        $default_lang = (int) Configuration::get('PS_LANG_DEFAULT');

        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Configurare si Sabloane'),
            ),
            'input' => array(
                array(
                    'type'     => 'text',
                    'label'    => $this->l('Connection ID'),
                    'name'     => 'SMSLINK_CONNECTION_ID',
                    'required' => true,
                    'desc'     => '<div>
                                        <a href="http://www.smslink.ro/inregistrare/" target="_blank"><img src="'.__PS_BASE_URI__.'modules/'.$this->name.'/smslink-logo.png" width="175" border="0" style="float: left; padding-right: 10px;" /></a>Pentru a obtine datele de conectare in platforma SMSLink, <a href="http://www.smslink.ro/inregistrare/" target="_blank">inregistrati-va gratuit</a>, apoi accesati optiunea <a href="http://www.smslink.ro/sms/gateway/setup.php" target="_blank">SMS Gateway - Configurare si setari</a> pentru a genera Connection ID / Password-ul pentru conexiunea dintre SMSLink si magazinul dvs. online. 
                                        <b>Beneficiati de asistenta gratuita</b> pentru pentru instalarea, configurarea si utilizarea modulului SMSLink, prin e-mail sau telefon, <b>24/7/365</b>. Ne puteti contacta pentru asistenta la <a href="http://www.smslink.ro/contact.php" target="_blank">aceste coordonate de contact</a>.                                        
                                   </div>'
                ),
                array(
                    'type'     => 'text',
                    'label'    => $this->l('Password'),
                    'name'     => 'SMSLINK_PASSWORD',
                    'required' => true,
                    'desc'     => '<div><b>Atentie! </b> Valorile pentru Connection ID / Password nu reprezinta numele de utilizator si parola contului dvs. de utilizator de pe SMSLink, ci datele de la sectiunea <a href="http://www.smslink.ro/sms/gateway/setup.php" target="_blank">SMS Gateway - Configurare si setari</a>.</div>'
                ),               
                array(
                    'type'     => 'checkbox',
                    'label'    => $this->l('Activare mod de teste'),
                    'name'     => 'SMSLINK_TEST',
                    'required' => false,
                    'values'   => array(
                        'query'  => array(
                                array('test' => null)
                            ),
                        'id'     => 'test',
                        'name'   => 'test'
                    ),
                    'desc'    => '<div>Atunci cand modul de teste este activat, toate SMS-urile generate ca urmare a comenzilor se vor transmite catre numarul de telefon pentru teste, in locul numarului de telefon al clientului dvs. Acest lucru va ajuta sa vizualizati pe telefon mesajele transmise clientilor dvs.</div>'
                ),
                array(
                    'type'     => 'text',
                    'label'    => $this->l('Numar telefon pentru teste'),
                    'name'     => 'SMSLINK_TEST_PHONE',
                    'required' => false,
                    'desc'    => '<div>Exemplu: 0720123456</div>'
                ),
                array(
                    'type'     => 'checkbox',
                    'label'    => $this->l('Utilizeaza conexiune')."<br />".$this->l('HTTPS (HTTP Secured) cu SMSLink'),
                    'name'     => 'SMSLINK_SECURE',
                    'required' => false,
                    'values'   => array(
                            'query'  => array(
                                    array('secure' => null)
                            ),
                            'id'     => 'secure',
                            'name'   => 'secure'
                    ),
                    'desc'    => '<div>Puteti utiliza, la alegere, conexiune HTTP sau HTTPS (HTTP Secured) cu SMSLink, pentru a creste astfel securitatea conexiunii.</div>'
                )
            )
        );

        $defaults = array(                
                 1 => 'Comanda dvs. pe '.Configuration::get('PS_SHOP_NAME').' cu nr. {order_number} a fost procesata si asteapta plata in valoare totala de {order_total} RON. Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                 2 => 'Plata pentru comanda cu numarul {order_number}, pe '.Configuration::get('PS_SHOP_NAME').', in valoare de {order_total} RON a fost aceptata. Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                 4 => 'Comanda dvs. pe '.Configuration::get('PS_SHOP_NAME').' cu nr. {order_number} in valoare de {order_total} RON a fost predata catre curier si va fi livrata in maxim 24 ore. Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                 5 => 'Comanda dvs. pe '.Configuration::get('PS_SHOP_NAME').' cu nr. {order_number} in valoare de {order_total} RON a fost livrata. Va multumim pentru alegerea facuta! Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                 6 => 'Comanda dvs. pe '.Configuration::get('PS_SHOP_NAME').' cu nr. {order_number} a fost anulata in cauza lipsei stoc sau termen de livrare mai mare de 10 zile. Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                 7 => 'Contravaloarea comenzii dvs. de pe '.Configuration::get('PS_SHOP_NAME').', cu nr. {order_number} in valoare de {order_total} RON a fost restituita. Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                 8 => 'Plata dvs. pentru comanda cu nr. {order_number} pe '.Configuration::get('PS_SHOP_NAME').', in valoare de {order_total} RON nu a putut fi procesata din cauza unei erori. Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                10 => 'Comanda dvs. pe '.Configuration::get('PS_SHOP_NAME').' cu nr. {order_number} a fost procesata si asteapta plata in valoare totala de {order_total} RON. Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                11 => 'Comanda dvs. pe '.Configuration::get('PS_SHOP_NAME').' cu nr. {order_number} a fost procesata si asteapta confirmarea de plata prin PayPal. Info-Line: '.Configuration::get('PS_SHOP_PHONE'),
                14 => 'Comanda dvs. pe '.Configuration::get('PS_SHOP_NAME').' cu nr. {order_number} a fost procesata in sistem ramburs. Suma totala de plata este {order_total} RON. Info-Line: '.Configuration::get('PS_SHOP_PHONE')

            );
        
        $orderStatuses = OrderState::getOrderStates($this->context->language->id);
        
        $orderVariabiles = array(
                "{order_number}",
                "{order_date}",
                "{order_total}",
                "{billing_first_name}",
                "{billing_last_name}",
                "{shipping_first_name}",
                "{shipping_last_name}",
                "{shipping_number}"
            );
        
        $orderVariabilesString = array();
        foreach ($orderVariabiles as $orderVariabileKey => $orderVariabile)
            $orderVariabilesString[] = '<a href="#InsertVariabile" onclick="insertAtCaret(\'[StatusTextBox]\', \''.$orderVariabile.'\');">'.$orderVariabile.'</a>';
        
        $orderVariabilesString = implode(", ", $orderVariabilesString);
        
        foreach ($orderStatuses as $key => $status) 
        {
            $fields_form[0]['form']['input'][] = array(
                        'type'     => 'textarea',
                        'rows'     => 2,
                        'label'    => 'Text SMS pentru comenzile cu starea<br />'.
                                      '<strong>'.$status['name'].'</strong><br />'.
                                      '(ID: '.$status['id_order_state'].')',                    
                        'name'     => 'SMSLINK_STATUS_'.$status['id_order_state'],
                        'required' => false,
                        'class'    => 'smslink_content',
                        'desc'     => '<div>'.
                                      (isset($defaults[$status['id_order_state']]) ? ' <b>Exemplu:</b> '.$defaults[$status['id_order_state']]."<br />" : '').  
                                      'Pentru a <b>nu</b> transmite SMS pentru comenzile avand aceasta stare, lasati acest camp liber.<br />'.
                                      '<b>Variabile disponibile pentru textul SMS-ului:</b> '.str_replace("[StatusTextBox]", "SMSLINK_STATUS_".$status['id_order_state'], $orderVariabilesString).
                                      (isset($defaults[$status['id_order_state']]) ? '<br /><a href="#Default" onclick="document.getElementById(\'SMSLINK_STATUS_'.$status['id_order_state'].'\').value = \''.$defaults[$status['id_order_state']].'\';">Seteaza textul SMS-ului implicit</a>' : '').
                                      '</div>'
                );
            
        }

        $fields_form[0]['form']['submit'] = array(
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right'
            );

        $helper = new HelperForm();

        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;
        
        $helper->title = $this->displayName;
        $helper->show_toolbar = false;        
        $helper->toolbar_scroll = true;      
        
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
            'save' =>  array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                '&token='.Tools::getAdminTokenLite('AdminModules'),
            ),
            'back' => array(
                'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list')
            )
        );
 
        $helper->fields_value['SMSLINK_CONNECTION_ID'] = Configuration::get('SMSLINK_CONNECTION_ID');
        $helper->fields_value['SMSLINK_PASSWORD'] = Configuration::get('SMSLINK_PASSWORD');
        
        $helper->fields_value['SMSLINK_TEST_'] = Configuration::get('SMSLINK_TEST');
        $helper->fields_value['SMSLINK_TEST_PHONE'] = Configuration::get('SMSLINK_TEST_PHONE');
        
        $helper->fields_value['SMSLINK_SECURE_'] = Configuration::get('SMSLINK_SECURE');
        
        $statuses = unserialize(Configuration::get('SMSLINK_STATUS'));
        foreach ($orderStatuses as $status) 
            $helper->fields_value['SMSLINK_STATUS_'.$status['id_order_state']] = isset($statuses[$status['id_order_state']]) ? $statuses[$status['id_order_state']] : '';

        return $helper->generateForm($fields_form);        
    }

    public function hookdisplayAdminOrderMainBottom($params)
    {
        if (!$this->active) 
        {
            return false;
        }

        if (Tools::isSubmit('submit_message')) 
        {
            require_once _PS_CLASS_DIR_.'order/Order.php';
            require_once _PS_CLASS_DIR_.'Customer.php';
            
            $id_order = (int)$params['id_order'];
            $order = new Order($id_order);
            $customer = new Customer((int)$order->id_customer);

            $phone = strval(Tools::getValue('Phone'));
            $message = strval(Tools::getValue('Message'));
            $phone = $this->Phone($phone);
            
            if (!empty($phone) && !empty($message)) 
            {
                $this->QueueSMS($phone, $message);
                $msg = 'Mesajul a fost trimis cu succes catre '.$phone."!";
                $msg_error = false;

                require_once _PS_CLASS_DIR_.'CustomerMessage.php';
                require_once _PS_CLASS_DIR_.'CustomerThread.php';
                
                $id_customer_thread = CustomerThread::getIdCustomerThreadByEmailAndIdOrder($customer->email, $order->id);
                
                if (!$id_customer_thread) 
                {
                    $customer_thread = new CustomerThread();
                    $customer_thread->id_contact = 0;
                    $customer_thread->id_customer = (int)$order->id_customer;
                    $customer_thread->id_shop = (int)$this->context->shop->id;
                    $customer_thread->id_order = (int)$order->id;
                    $customer_thread->id_lang = (int)$this->context->language->id;
                    $customer_thread->email = $customer->email;
                    $customer_thread->status = 'open';
                    $customer_thread->token = Tools::passwdGen(12);
                    $customer_thread->add();                    
                } 
                else 
                {
                    $customer_thread = new CustomerThread((int)$id_customer_thread);                    
                }
                
                $customer_message = new CustomerMessage();
                $customer_message->id_customer_thread = $customer_thread->id;
                $customer_message->id_employee = (int)$this->context->employee->id;
                $customer_message->message = 'SMS transmis catre: '.$phone.', cu textul: '.$message;
                $customer_message->private = 1;
                $customer_message->add();                
            } 
            else 
            {
                $msg = 'Numarul de telefon nu este valid.';
                $msg_error = true;
            }
            
            $this->context->smarty->assign(
                    array(
                        'action_message' => $msg,
                        'action_error'   => $msg_error
                    )
                );            
        }

        return $this->display(__FILE__, 'hook_sms_form.tpl');        
    }

    public function hookDisplayOrderConfirmation($params)
    {
        print_r($params, true);
    }

    public function hookActionOrderStatusPostUpdate($params)
    {
        if (!$this->active) 
            return false;

        $orderId = $params['id_order'];
        $statusId = $params['newOrderStatus']->id;

        $statuses = unserialize(Configuration::get('SMSLINK_STATUS'));
        
        if (isset($statuses[$statusId])) 
        {
            $order = new Order($orderId);
            
            $billingAddress = new Address($order->id_address_invoice);
            $shippingAddress = new Address($order->id_address_delivery);

            $Phone = $this->ChoosePhone($billingAddress->phone, $billingAddress->phone_mobile);

            if ($Phone == false)
                $Phone = $this->ChoosePhone($shippingAddress->phone, $shippingAddress->phone_mobile);
                
            $Message = $statuses[$statusId];
            
            $replace = array(
                    '{billing_first_name}'  => $billingAddress->firstname,
                    '{billing_last_name}'   => $billingAddress->lastname,
                    '{shipping_first_name}' => $shippingAddress->firstname,
                    '{shipping_last_name}'  => $shippingAddress->lastname,
                    '{order_number}'        => $order->reference,
                    '{shipping_number}'     => $order->getWsShippingNumber(),
                    '{order_date}'          => date('d-m-Y', strtotime($order->date_add)),
                    '{order_total}'         => number_format($order->total_paid, 2, '.', '')
                );
            file_put_contents("debug.txt", var_export($order, true));   
            foreach ($replace as $key => $value) 
                $Message = str_replace($key, $value, $Message);

            $this->QueueSMS($Phone, $Message);            
        }        
    }

    public function ChoosePhone($Landline, $Mobile)
    {        
        $Landline = $this->Phone($Landline);
        $Mobile   = $this->Phone($Mobile);
        
        if (!empty($Mobile)) 
        {
            if (strlen($Mobile) > 0)
                return $Mobile;
        }
        
        if (!empty($Landline))
        {
            if (strlen($Landline) > 0)
                return $Landline;
        }
        
        return false;                
    }

    public function Phone($Phone)
    {
        $ReplaceOccurances = 1;
        
        $Phone = str_replace("+", "00", $Phone, $ReplaceOccurances);
        $Phone = preg_replace('/\D/', '', $Phone);
        
        if (substr($Phone, 0, 4) == "0040")
            $Phone = substr($Phone, 3);
        
        if (substr($Phone, 0, 2) == "40")
            $Phone = substr($Phone, 1);
        
        if (strlen($Phone) < 10)
            if ((isset($Phone[0])) and ($Phone[0] == "7"))
                $Phone = "0".$Phone;
                  
        return $Phone;                
    }

    public function Credit($TestConnection = 1)
    {
        $ConnectionID = Configuration::get('SMSLINK_CONNECTION_ID');

        $Password = Configuration::get('SMSLINK_PASSWORD');
        
        if ((strlen($ConnectionID) == 0) or (strlen($Password) == 0))
        {
            $Result = "Datele de autentificare pentru platforma SMSLink <b>nu sunt configurate</b>. Va rugam consultati sectiunea <a href='index.php?controller=AdminModules&configure=smslink&token=".Tools::getAdminTokenLite('AdminModules')."'>Configurare pentru modulul SMSLink</a>.";            
        }
        else
        {
            $SecureStatus = Configuration::get('SMSLINK_SECURE');
            
            $ch = curl_init();      

            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

            $URL = "http://www.smslink.ro";

            if ($SecureStatus == 1)
                $URL = "https://secure.smslink.ro";

            $URL = $URL.'/sms/gateway/communicate/index.php?connection_id='.$ConnectionID.'&password='.$Password.'&mode=credit&version='.$this->agent;

            curl_setopt($ch, CURLOPT_URL, $URL);

            if (strpos($URL, "https://") !== false)
            {
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            }

            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);

            $Response = curl_exec($ch);
            
            $curl_errno = curl_errno($ch);
            $curl_error = curl_error($ch);
           
            if ($curl_errno == 0)
            {
                $Response = explode(";", $Response);

                if ($Response[0] == "MESSAGE") 
                {
                    $Variabiles = explode(",", $Response[3]);
                    
                    if ($TestConnection == 1) $Result = "Conexiune realizata cu succes. Mai aveti disponibile ".$Variabiles[0]." SMS la data de ".date("d-m-Y H:i:s", $Variabiles[1]).".";
                        else $Result = "Mai aveti ".$Variabiles[0]." SMS la ".date("d-m-Y H:i:s", $Variabiles[1]).".";
                }
                else 
                {
                    $Result = "Datele de autentificare pentru platforma SMSLink <b>sunt incorecte</b>. Va rugam consultati sectiunea <a href='index.php?controller=AdminModules&configure=smslink&token=".Tools::getAdminTokenLite('AdminModules')."'>Configurare pentru modulul SMSLink</a>.";
                }                 
            }
            else
            {
                 $Result = "Creditul nu a putut fi interogat, va rugam incercati mai tarziu.";
            }            
        }
        
        return $Result;        
    }
    
    public function QueueSMS($receiver, $message, $disable_test = 0)
    {
        $ConnectionID = Configuration::get('SMSLINK_CONNECTION_ID');
        $Password = Configuration::get('SMSLINK_PASSWORD');
        
        $TestStatus = Configuration::get('SMSLINK_TEST');
        $TestPhone = $this->Phone(Configuration::get('SMSLINK_TEST_PHONE'));
        
        $SecureStatus = Configuration::get('SMSLINK_SECURE');
        
        if ((strlen($ConnectionID) == 0) or (strlen($Password) == 0))
            return false;
        
        if ($disable_test == 0)
        {
            if (($TestStatus) and (strlen($TestPhone) == 0))
                return false;
            
            if (($TestStatus) and (strlen($TestPhone) > 0)) 
                $receiver = $TestPhone;
        }
        
        $receiver = $this->Phone($receiver);
        $message  = $this->MessageText($message);
        
        if (strlen($message) > 0) 
        {
            $ch = curl_init();

            $TimestampQueued = date("Y-m-d H:i:s");
            
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                      
            $URL = "http://www.smslink.ro";
            if ($SecureStatus == 1)
                $URL = "https://secure.smslink.ro";
            
            $URL = $URL.'/sms/gateway/communicate/index.php?connection_id='.$ConnectionID.'&password='.$Password.'&to='.$receiver.'&message='.urlencode($message).'&version='.$this->agent;
            
            curl_setopt($ch, CURLOPT_URL, $URL);                   
                 
            if (strpos($URL, "https://") !== false)
            {
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            }
            
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30); 
            
            $TimestampSent = date("Y-m-d H:i:s");
            
            $RemoteStatus    = 0;
            $RemoteMessageID = 0;
            
            $RemoteResponse = array(
                    "Response"   => curl_exec($ch),                    
                    "Parsed"     => "",
                    "Variabiles" => NULL
                );            
                        
            $curl_errno = curl_errno($ch);
            $curl_error = curl_error($ch);

            if ($curl_errno == 0)
            {
                $RemoteResponse["Parsed"] = explode(";", $RemoteResponse["Response"]);
                
                if ($RemoteResponse["Parsed"][0] == "MESSAGE") $RemoteStatus = 1;
                    else $RemoteStatus = 2;
                
                if ($RemoteStatus == 1)
                {
                    $RemoteResponse["Variabiles"] = explode(",", $RemoteResponse["Parsed"][3]);
                    $RemoteMessageID = $RemoteResponse["Variabiles"][0];
                }            
            }
            else
            {
                $RemoteStatus = 3;
                $RemoteResponse["Response"] = "CONNECTION ERROR;".$curl_errno.";".$curl_error;                               
            }
            
            Db::getInstance()->insert(
                    'smslink_log', 
                    array(
                        'receiver'          => pSQL($receiver),
                        'message'           => pSQL($message),
                        'timestamp_queued'  => $TimestampQueued,
                        'timestamp_sent'    => $TimestampSent,
                        'remote_message_id' => (int) $RemoteMessageID,
                        'remote_status'     => (int) $RemoteStatus,
                        'remote_response'   => pSQL($RemoteResponse["Response"])                
                    )
               );
            
            curl_close($ch);            
        }        
    }
           
    public function MessageText($Text)
    {
        $Find    = array("\xC4\x82", "\xC4\x83", "\xC3\x82", "\xC3\xA2", "\xC3\x8E", "\xC3\xAE", "\xC8\x98", "\xC8\x99", "\xC8\x9A", "\xC8\x9B", "\xC5\x9E", "\xC5\x9F", "\xC5\xA2", "\xC5\xA3", "\xC3\xA3", "\xC2\xAD", "\xe2\x80\x93");
        $Replace = array("A", "a", "A", "a", "I", "i", "S", "s", "T", "t", "S", "s", "T", "t", "a", " ", "-");
        
        $Text = str_replace($Find, $Replace, $Text);
        $Text = trim($Text);
        
        return $Text;        
    }
}
