<?php

namespace SMSLink\SMSGateway\Helper;

use \Magento\Framework\App\ObjectManager as ObjectManager;
use \Magento\Framework\Event\Observer as Observer;
use \Magento\Store\Model\ScopeInterface as ScopeInterface;
use \Magento\Framework\App\Helper\AbstractHelper as AbstractHelper;

class Data extends AbstractHelper
{   
    protected $_platform         = 'MAGENTO2'; // eCommerce Platform
    protected $_version          = '1.0.0';    // SMSLink Plugin Version
    
    protected $_enable_https     = 0;          // Default fallback value (change it from admin panel)
    
    protected $_enable_debug     = 0;          // Default fallback value (change it from admin panel)
    protected $_enable_logs      = 0;          // Default fallback value (change it from admin panel)
    
    public function SMSGatewayConnectionID()
    {
        return $this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_username');
    }
 
    public function SMSGatewayPassword()
    {
        return $this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_password');
    }

    public function isCustomerMessageEnabled($order_status = null)
    {
        $order_status = str_replace("/", "_", $order_status);
        
        switch($order_status)

        {
            case "new_order":

                $status = $this->getConfig('smslink_smsgateway_orders/new_order/smslink_new_order_status');

                break;

            default:

                $status = $this->getConfig('smslink_smsgateway_orders/'.$order_status.'/smslink_'.$order_status.'_status');

                break;

        }

        

        return $status;
        
    }
    
    public function getCustomerMessage($order_status = null)
    {
        $order_status = str_replace("/", "_", $order_status);
        
        switch($order_status)
        {
            case "new_order":
                $message = $this->getConfig('smslink_smsgateway_orders/new_order/smslink_new_order_message');
                break;
            default:
                $message = $this->getConfig('smslink_smsgateway_orders/'.$order_status.'/smslink_'.$order_status.'_message');
                break;
        }
        
        return $message;
        
    }
    
    public function getConfig($configPath)
    {
        return $this->scopeConfig->getValue(
                $configPath,
                ScopeInterface::SCOPE_STORE
            );
        
    }

    public function SendSMS($username, $password, $destination = null, $message = null)
    {
        $session_id = uniqid();
        
        $username = trim($username);
        $password = trim($password);
                
        if ((strlen($username) > 0) and (strlen($password) > 0))
        {
            $enable_https = $this->_enable_https;
            if (!empty($this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_https_status')))
                $enable_https = $this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_https_status');
            
            $destination = $this->Phone($destination);
            $message = $this->MessageText($message);
            
            $url = (($enable_https == 1) ? "https://secure.smslink.ro" : "http://www.smslink.ro").

                   "/sms/gateway/communicate/index.php".

                   "?connection_id=".urlencode($username).

                   "&password=".urlencode($password).

                   "&to=".urlencode($destination).

                   "&message=".urlencode($message).
                   "&version=".urlencode($this->_platform."_".$this->_version);

    
            $enable_fopen = 0;
            if (!empty($this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_fopen_status')))
                $enable_fopen = $this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_fopen_status');
                
            $this->EventsLog("Session: ".$session_id.": Request: Sending SMS using Connection ID: ".$username.", HTTPS: ".$enable_https.", Method: ".(($enable_fopen == 1) ? "fopen URL wrappers" : "CURL").", to Destination: ".$destination." with Message: ".$message, "log");

            

            if ($enable_fopen == 1)
            {
                $Result = @file_get_contents($url);   
                 
            }
            else
            {
                $ch = curl_init();
                
                curl_setopt($ch, CURLOPT_URL, $url);
    
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
                curl_setopt($ch, CURLOPT_HEADER, 0);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                
                if (strpos($url, "https://") !== false)
                {
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                }
    
                $Result = @curl_exec($ch);
                
                $curl_errno = curl_errno($ch);

                $curl_error = curl_error($ch);
                
                curl_close($ch);
                
            }
    
            if ($Result !== false)
            {
                $this->EventsLog("Session: ".$session_id.": Receive: ".$Result, "log");
                
            }
            else
            {
                if ($enable_fopen == 1) $this->EventsLog("Session: ".$session_id.": Failed to connect to SMS Gateway using fopen URL wrappers.", "log");
                    else $this->EventsLog("Session: ".$session_id.": Failed to connect to SMS Gateway using CURL (error no. ".$curl_errno.", error message ".$curl_error.").", "log");
                    
            }
            
        }
        else
        {
            $this->EventsLog("Session: ".$session_id.": SMS Gateway Connection is not configured. Please fill in SMS Gateway Connection ID and Password in your admin panel.", "log");
            
        }
        
        return true;
        
    }
    
    public function Phone($Phone)

    {

        $Phone = preg_replace('/\D/', '', $Phone);

    

        if (substr($Phone, 0, 4) == "0040")

            $Phone = substr($Phone, 3);

    

        if (substr($Phone, 0, 2) == "40")

            $Phone = substr($Phone, 1);

    

        if (strlen($Phone) < 10)

            if ($Phone[0] == "7")

            $Phone = "0".$Phone;

    

        return $Phone;

    

    }
    
    public function ParseMessageText($message, $data)
    {
        $keywords = array(
                '{orderid}',
                '{fname}',
                '{mname}',
                '{lname}',
                '{ordertotal}',
                '{awb}'
            );
        
        $message = str_replace($keywords, $data, $message);
        
        return $message;
        
    }
    
    public function MessageText($Text)

    {

        $Find = array("\xC4\x82", "\xC4\x83", "\xC3\x82", "\xC3\xA2", "\xC3\x8E", "\xC3\xAE", "\xC8\x98", "\xC8\x99", "\xC8\x9A", "\xC8\x9B", "\xC5\x9E", "\xC5\x9F", "\xC5\xA2", "\xC5\xA3", "\xC3\xA3", "\xC2\xAD", "\xe2\x80\x93");
        $Replace = array("A", "a", "A", "a", "I", "i", "S", "s", "T", "t", "S", "s", "T", "t", "a", " ", "-");
        
        $Text = str_replace($Find, $Replace, $Text);
        $Text = trim($Text);
        
        return $Text;


    }    
    
    public function EventsLog($message, $log_type = "debug")
    {
        if ($log_type == "debug")
        {
            $enable_debug = $this->_enable_debug;
            if (!empty($this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_debug_status')))
                $enable_debug = $this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_debug_status');
            
            if ($enable_debug == 1)
                file_put_contents("var/log/sms.debug.log", date("Y-m-d H:i:s")." - ".$message."\r\n", FILE_APPEND); 
        
        }
        elseif ($log_type == "log")
        {
            $enable_logs = $this->_enable_logs;
            if (!empty($this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_logs_status')))

                $enable_logs = $this->getConfig('smslink_smsgateway_configuration/basic_configuration/smslink_logs_status');
            

            if ($enable_logs == 1)

                file_put_contents("var/log/sms.log", date("Y-m-d H:i:s")." - ".$message."\r\n", FILE_APPEND);
        
        }
        
        return true;
           
    }
    
    public function getOrder(Observer $observer)
    {
        $order = $observer->getOrder();
        
        $orderId = $order->getIncrementId();
        
        $objectManager = ObjectManager::getInstance();
        $order = $objectManager->get('Magento\Sales\Model\Order');
        $orderInformation = $order->loadByIncrementId($orderId);
        
        return $orderInformation;
        
    }
    
}