<?php

namespace SMSLink\SMSGateway\Observer;

use Magento\Framework\Event\ObserverInterface;
use \Magento\Framework\Event\Observer       as Observer;
use \Magento\Framework\View\Element\Context as Context;
use \SMSLink\SMSGateway\Helper\Data         as Helper;

class NewOrder implements ObserverInterface
{
    const AJAX_PARAM_NAME = 'infscroll';
    const AJAX_HANDLE_NAME = 'infscroll_ajax_request';

    protected $_request;
    protected $_layout;
    protected $_cache;
    protected $_helper;

    protected $username;
    protected $password;    
    protected $destination;
    protected $message;

    public function __construct(Context $context, Helper $helper) 
    {
        $this->_helper  = $helper;
        $this->_request = $context->getRequest();
        $this->_layout  = $context->getLayout();
        
    }
    
    public function execute(Observer $observer)
    {
        $this->_helper->EventsLog("NewOrder -> Execute Started");
        
        $this->_helper->EventsLog("NewOrder -> REQUEST_URI: ".$_SERVER['REQUEST_URI']);
        
        if (strpos($_SERVER['REQUEST_URI'], "admin") == false)
        {
            $this->username = $this->_helper->SMSGatewayConnectionID();
            $this->password = $this->_helper->SMSGatewayPassword();
            $this->message = $this->_helper->getCustomerMessage("new_order");
            
            $this->_helper->EventsLog("NewOrder -> Message[Template]: ".$this->message);
            
            if ($this->_helper->isCustomerMessageEnabled("new_order") == 1)
            {        
                $order = $this->_helper->getOrder($observer);
                
                $orderData = array(
                        'orderid'    => $order->getIncrementId(),
                        'fname'      => $order->getCustomerFirstname(),
                        'mname'      => $order->getCustomerMiddlename(),
                        'lname'      => $order->getCustomerLastname(),
                        'ordertotal' => number_format($order->getGrandTotal(), 2)
                    );

                $this->destination  = $order->getBillingAddress()->getTelephone();
                $this->_helper->EventsLog("NewOrder -> Destination: ".$this->destination);
                
                $this->message      = $this->_helper->ParseMessageText($this->message, $orderData);
                $this->_helper->EventsLog("NewOrder -> Message[Parsed]: ".$this->message);
                
                $this->_helper->SendSMS(
                    $this->username,
                    $this->password,
                    $this->destination,
                    $this->message
                );
                    
            }
                        
        }
        else
        {
            $this->_helper->EventsLog("NewOrder -> Order is not a New Order");
            
        }
        
        $this->_helper->EventsLog("NewOrder -> Execute Ended");

    }

}
