<?php
class ControllerSmslinkAbout extends Controller {
    public function index()
    {
        $this->load->language('extension/module/smslink');
        $this->document->setTitle($this->language->get('heading_about'));

        $this->load->model('design/layout');
        $data['heading_title'] = $this->language->get('heading_about');
        $data['token'] = $this->session->data['token'];

        # breadcrumbs
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_module'),
            'href' => $this->url->link('marketplace/extension', 'token=' . $this->session->data['token'] . '&type=module', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/smslink', 'token=' . $this->session->data['token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_about'),
            'href' => $this->url->link('smslink/about', 'token=' . $this->session->data['token'], true)
        );

        # page links
        $data['history_link'] = $this->url->link('smslink/history', 'token=' . $this->session->data['token'], true);
        $data['history_text'] = $this->language->get('text_history');
        $data['about_link'] = $this->url->link('smslink/about', 'token=' . $this->session->data['token'], true);
        $data['about_text'] = $this->language->get('text_about');
        $data['test_link'] = $this->url->link('smslink/test', 'token=' . $this->session->data['token'], true);
        $data['test_text'] = $this->language->get('text_test');

        # texts
        $data['about_smslink'] = $this->language->get('about_smslink');

        # common template
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('smslink/about', $data));
    }
}
